#include "pvmuser.h"
#include "pvm_consts.h"
#include "xab.h"

void
FUNCTION(finitiate) ARGS(`STRING_ARG(aout), STRING_ARG(arch), inum')
STRING_ARG_DECL(aout);
STRING_ARG_DECL(arch);
int *inum;
{
	char taout[MAX_PROC_NAME + 1];
	char tarch[MAX_ARCH_NAME + 1];

	/*
	 * Copy the program and arch names to make sure there's
	 * a NUL at the end.
	 * If either the program name or the arch name is too
	 * long, just return an error.
	 */

	if (STRING_LEN(aout) > MAX_PROC_NAME
		|| STRING_LEN(arch) > MAX_ARCH_NAME) {
		*inum = pvm_uerr("finitiate", PvmTooLong);
		return;
	}
	strncpy(taout, STRING_PTR(aout), STRING_LEN(aout));
	taout[STRING_LEN(aout)] = '\0';

	/*
	 * if arch parameter begins with '*', pass a NULL pointer to
	 * initiate which will allow execution on any machine.
	 */
	if (*(STRING_PTR(arch)) == '*') {
		*inum = initiate(taout, (char*)0);
	}
	else {
		strncpy(tarch, STRING_PTR(arch), STRING_LEN(arch));
		tarch[STRING_LEN(arch)] = '\0';
		*inum = initiate(taout, tarch);
	}
}
